package org.kodein.emoji.smileys_emotion.face_concerned

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _HushedFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😯",
        description = "hushed face",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("hushed-face", "surprised", "hushed"),
        emoticons = listOf(":o"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-concerned: hushed face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.HushedFace: Emoji get() = _HushedFace

/**
 * Alias to emoji [HushedFace] (Smileys & Emotion: face-concerned: hushed face).
*/
public val Emoji.Companion.Surprised: Emoji get() = _HushedFace

/**
 * Alias to emoji [HushedFace] (Smileys & Emotion: face-concerned: hushed face).
*/
public val Emoji.Companion.Hushed: Emoji get() = _HushedFace
