package org.kodein.emoji.smileys_emotion.face_unwell

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SneezingFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🤧",
        description = "sneezing face",
        unicodeVersion = UnicodeVersion(3, 0),
        aliases = listOf("sneezing-face", "sneeze"),
        emoticons = listOf("(*´台｀*)"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-unwell: sneezing face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SneezingFace: Emoji get() = _SneezingFace

/**
 * Alias to emoji [SneezingFace] (Smileys & Emotion: face-unwell: sneezing face).
*/
public val Emoji.Companion.Sneeze: Emoji get() = _SneezingFace
