package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _NewButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🆕",
        description = "NEW button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("new-button", "new"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Symbols: alphanum: NEW button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.NewButton: Emoji get() = _NewButton

/**
 * Alias to emoji [NewButton] (Symbols: alphanum: NEW button).
*/
public val Emoji.Companion.New: Emoji get() = _NewButton
