package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _GreenCircle: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🟢",
        description = "green circle",
        unicodeVersion = UnicodeVersion(12, 0),
        aliases = listOf("green-circle", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: geometric: green circle.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.GreenCircle: Emoji get() = _GreenCircle
