package org.kodein.emoji.symbols.math

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllMath() {
    add(intArrayOf(0x2716, 0xfe0f), _Multiply)
    add(intArrayOf(0x2716), _Multiply)
    add(intArrayOf(0x2795), _Plus)
    add(intArrayOf(0x2796), _Minus)
    add(intArrayOf(0x2797), _Divide)
    add(intArrayOf(0x1f7f0), _HeavyEqualsSign)
    add(intArrayOf(0x267e, 0xfe0f), _Infinity)
    add(intArrayOf(0x267e), _Infinity)
}

internal suspend fun SequenceScope<Emoji>.yieldAllMath() {
    yield(_Multiply)
    yield(_Plus)
    yield(_Minus)
    yield(_Divide)
    yield(_HeavyEqualsSign)
    yield(_Infinity)
}

internal val countMath = 6

/**
 * All Emoji of the Symbols: math subgroup.
*/
public fun Emoji.Companion.sequenceMath(): Sequence<Emoji> =
    sequence { yieldAllMath() }

/**
 * All Emoji of the Symbols: math subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listMath(): List<Emoji> =
    ArrayList<Emoji>(countMath).also { list -> sequenceMath().forEach { list.add(it) } }

@Deprecated("Renamed listMath.", replaceWith = ReplaceWith("listMath()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allMath(): List<Emoji> =
    listMath()
