package org.kodein.emoji.symbols.other_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllOtherSymbol() {
    add(intArrayOf(0x2695, 0xfe0f), _MedicalSymbol)
    add(intArrayOf(0x2695), _MedicalSymbol)
    add(intArrayOf(0x267b, 0xfe0f), _RecyclingSymbol)
    add(intArrayOf(0x267b), _RecyclingSymbol)
    add(intArrayOf(0x269c, 0xfe0f), _FleurDeLis)
    add(intArrayOf(0x269c), _FleurDeLis)
    add(intArrayOf(0x1f531), _TridentEmblem)
    add(intArrayOf(0x1f4db), _NameBadge)
    add(intArrayOf(0x1f530), _JapaneseSymbolForBeginner)
    add(intArrayOf(0x2b55), _HollowRedCircle)
    add(intArrayOf(0x2705), _CheckMarkButton)
    add(intArrayOf(0x2611, 0xfe0f), _CheckBoxWithCheck)
    add(intArrayOf(0x2611), _CheckBoxWithCheck)
    add(intArrayOf(0x2714, 0xfe0f), _CheckMark)
    add(intArrayOf(0x2714), _CheckMark)
    add(intArrayOf(0x274c), _CrossMark)
    add(intArrayOf(0x274e), _CrossMarkButton)
    add(intArrayOf(0x27b0), _CurlyLoop)
    add(intArrayOf(0x27bf), _DoubleCurlyLoop)
    add(intArrayOf(0x303d, 0xfe0f), _PartAlternationMark)
    add(intArrayOf(0x303d), _PartAlternationMark)
    add(intArrayOf(0x2733, 0xfe0f), _EightSpokedAsterisk)
    add(intArrayOf(0x2733), _EightSpokedAsterisk)
    add(intArrayOf(0x2734, 0xfe0f), _EightPointedStar)
    add(intArrayOf(0x2734), _EightPointedStar)
    add(intArrayOf(0x2747, 0xfe0f), _Sparkle)
    add(intArrayOf(0x2747), _Sparkle)
    add(intArrayOf(0xa9, 0xfe0f), _Copyright)
    add(intArrayOf(0xa9), _Copyright)
    add(intArrayOf(0xae, 0xfe0f), _Registered)
    add(intArrayOf(0xae), _Registered)
    add(intArrayOf(0x2122, 0xfe0f), _TradeMark)
    add(intArrayOf(0x2122), _TradeMark)
    add(intArrayOf(0x1fadf), _Splatter)
}

internal suspend fun SequenceScope<Emoji>.yieldAllOtherSymbol() {
    yield(_MedicalSymbol)
    yield(_RecyclingSymbol)
    yield(_FleurDeLis)
    yield(_TridentEmblem)
    yield(_NameBadge)
    yield(_JapaneseSymbolForBeginner)
    yield(_HollowRedCircle)
    yield(_CheckMarkButton)
    yield(_CheckBoxWithCheck)
    yield(_CheckMark)
    yield(_CrossMark)
    yield(_CrossMarkButton)
    yield(_CurlyLoop)
    yield(_DoubleCurlyLoop)
    yield(_PartAlternationMark)
    yield(_EightSpokedAsterisk)
    yield(_EightPointedStar)
    yield(_Sparkle)
    yield(_Copyright)
    yield(_Registered)
    yield(_TradeMark)
    yield(_Splatter)
}

internal val countOtherSymbol = 22

/**
 * All Emoji of the Symbols: other-symbol subgroup.
*/
public fun Emoji.Companion.sequenceOtherSymbol(): Sequence<Emoji> =
    sequence { yieldAllOtherSymbol() }

/**
 * All Emoji of the Symbols: other-symbol subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listOtherSymbol(): List<Emoji> =
    ArrayList<Emoji>(countOtherSymbol).also { list -> sequenceOtherSymbol().forEach { list.add(it) } }

@Deprecated("Renamed listOtherSymbol.", replaceWith = ReplaceWith("listOtherSymbol()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allOtherSymbol(): List<Emoji> =
    listOtherSymbol()
