package org.kodein.emoji.symbols.punctuation

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ExclamationQuestionMark: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⁉️",
        description = "exclamation question mark",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("exclamation-question-mark", "-"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Symbols: punctuation: exclamation question mark.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ExclamationQuestionMark: Emoji get() = _ExclamationQuestionMark
