package org.kodein.emoji.symbols.religion

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PeaceSymbol: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "☮️",
        description = "peace symbol",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("peace-symbol", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Symbols: religion: peace symbol.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PeaceSymbol: Emoji get() = _PeaceSymbol
