package org.kodein.emoji.symbols.zodiac

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Cancer: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "♋",
        description = "Cancer",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("cancer", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Symbols: zodiac: Cancer.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Cancer: Emoji get() = _Cancer
