package org.kodein.emoji.travel_places.hotel

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllHotel() {
    add(intArrayOf(0x1f6ce, 0xfe0f), _BellhopBell)
    add(intArrayOf(0x1f6ce), _BellhopBell)
    add(intArrayOf(0x1f9f3), _Luggage)
}

internal suspend fun SequenceScope<Emoji>.yieldAllHotel() {
    yield(_BellhopBell)
    yield(_Luggage)
}

internal val countHotel = 2

/**
 * All Emoji of the Travel & Places: hotel subgroup.
*/
public fun Emoji.Companion.sequenceHotel(): Sequence<Emoji> =
    sequence { yieldAllHotel() }

/**
 * All Emoji of the Travel & Places: hotel subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listHotel(): List<Emoji> =
    ArrayList<Emoji>(countHotel).also { list -> sequenceHotel().forEach { list.add(it) } }

@Deprecated("Renamed listHotel.", replaceWith = ReplaceWith("listHotel()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allHotel(): List<Emoji> =
    listHotel()
