package org.kodein.emoji.travel_places.sky_weather

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WaterWave: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🌊",
        description = "water wave",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("water-wave", "ocean"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Travel & Places: sky & weather: water wave.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WaterWave: Emoji get() = _WaterWave

/**
 * Alias to emoji [WaterWave] (Travel & Places: sky & weather: water wave).
*/
public val Emoji.Companion.Ocean: Emoji get() = _WaterWave
