/*
 * Decompiled with CFR 0.152.
 */
package org.kodein.emoji;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a8\u0006\r"}, d2={"isCodePointInOneChar", "", "code", "", "codePointCharLength", "codePointAt", "string", "", "index", "codePoints", "", "str", "", "emoji-kt"})
@SourceDebugExtension(value={"SMAP\nCodePoints.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodePoints.kt\norg/kodein/emoji/CodePointsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,46:1\n1#2:47\n*E\n"})
public final class CodePointsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isCodePointInOneChar(int code) {
        boolean bl;
        if (0 <= code) {
            if (code < 55296) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (57344 > code) return false;
        if (code >= 65536) return false;
        return true;
    }

    public static final int codePointCharLength(int code) {
        return CodePointsKt.isCodePointInOneChar(code) ? 1 : 2;
    }

    public static final int codePointAt(@NotNull CharSequence string, int index) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (CodePointsKt.isCodePointInOneChar(string.charAt(index))) {
            return string.charAt(index);
        }
        char highSurrogate = string.charAt(index);
        char lowSurrogate = string.charAt(index + 1);
        if (!((highSurrogate & 0xFC00) == 55296)) {
            boolean bl = false;
            throw new IllegalStateException(("Invalid high surrogate at " + index).toString());
        }
        if (!((lowSurrogate & 0xFC00) == 56320)) {
            boolean bl = false;
            throw new IllegalStateException(("Invalid low surrogate at " + index).toString());
        }
        int highBits = highSurrogate & 0x3FF;
        int lowBits = lowSurrogate & 0x3FF;
        return (highBits << 10 | lowBits) + 65536;
    }

    @NotNull
    public static final int[] codePoints(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        int index = 0;
        int count = 0;
        while (index < str.length()) {
            int code = CodePointsKt.codePointAt(str, index);
            index += CodePointsKt.codePointCharLength(code);
            ++count;
        }
        int[] array = new int[count];
        index = 0;
        count = 0;
        while (index < str.length()) {
            int code;
            array[count] = code = CodePointsKt.codePointAt(str, index);
            index += CodePointsKt.codePointCharLength(code);
            ++count;
        }
        return array;
    }
}

