package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagKosovo: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇽🇰",
        description = "flag: Kosovo",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-kosovo", "kosovo-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Kosovo.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagKosovo: Emoji get() = _FlagKosovo

/**
 * Alias to emoji [FlagKosovo] (Flags: country-flag: flag: Kosovo).
*/
public val Emoji.Companion.KosovoFlag: Emoji get() = _FlagKosovo
