package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagMarshallIslands: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇲🇭",
        description = "flag: Marshall Islands",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-marshall-islands", "marshall-islands-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Marshall Islands.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagMarshallIslands: Emoji get() = _FlagMarshallIslands

/**
 * Alias to emoji [FlagMarshallIslands] (Flags: country-flag: flag: Marshall Islands).
*/
public val Emoji.Companion.MarshallIslandsFlag: Emoji get() = _FlagMarshallIslands
