package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagStHelena: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇸🇭",
        description = "flag: St. Helena",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-st-helena", "st-helena-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: St. Helena.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagStHelena: Emoji get() = _FlagStHelena

/**
 * Alias to emoji [FlagStHelena] (Flags: country-flag: flag: St. Helena).
*/
public val Emoji.Companion.StHelenaFlag: Emoji get() = _FlagStHelena
