package org.kodein.emoji.objects.office

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FileCabinet: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🗄️",
        description = "file cabinet",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("file-cabinet", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: office: file cabinet.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FileCabinet: Emoji get() = _FileCabinet
