package org.kodein.emoji.objects.other_object

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllOtherObject() {
    add(intArrayOf(0x1f5ff), _Moai)
    add(intArrayOf(0x1faaa), _IdentificationCard)
    add(intArrayOf(0x1faa7), _Placard)
    add(intArrayOf(0x1f9ff), _NazarAmulet)
    add(intArrayOf(0x1faac), _Hamsa)
    add(intArrayOf(0x26b1, 0xfe0f), _FuneralUrn)
    add(intArrayOf(0x26b1), _FuneralUrn)
    add(intArrayOf(0x26b0, 0xfe0f), _Coffin)
    add(intArrayOf(0x26b0), _Coffin)
    add(intArrayOf(0x1faa6), _Headstone)
    add(intArrayOf(0x1f6ac), _Cigarette)
}

internal fun MutableList<Emoji>.addAllOtherObject() {
    add(_Moai)
    add(_IdentificationCard)
    add(_Placard)
    add(_NazarAmulet)
    add(_Hamsa)
    add(_FuneralUrn)
    add(_Coffin)
    add(_Headstone)
    add(_Cigarette)
}

/**
 * All Emoji of the Objects: other-object subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allOtherObject(): List<Emoji> =
    ArrayList<Emoji>(9).apply { addAllOtherObject() }
