package org.kodein.emoji.smileys_emotion.face_affection

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SmilingFaceWithHearts: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🥰",
        description = "smiling face with hearts",
        unicodeVersion = UnicodeVersion(11, 0),
        aliases = listOf("smiling-face-with-hearts", "heart-face", "3-hearts"),
        emoticons = listOf("<3:)"),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-affection: smiling face with hearts.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SmilingFaceWithHearts: Emoji get() = _SmilingFaceWithHearts

/**
 * Alias to emoji [SmilingFaceWithHearts] (Smileys & Emotion: face-affection: smiling face with hearts).
*/
public val Emoji.Companion.HeartFace: Emoji get() = _SmilingFaceWithHearts
