package org.kodein.emoji.travel_places.transport_ground

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _OncomingBus: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🚍",
        description = "oncoming bus",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("oncoming-bus", "bus-front"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Travel & Places: transport-ground: oncoming bus.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.OncomingBus: Emoji get() = _OncomingBus

/**
 * Alias to emoji [OncomingBus] (Travel & Places: transport-ground: oncoming bus).
*/
public val Emoji.Companion.BusFront: Emoji get() = _OncomingBus
