package org.kodein.emoji.activities.event

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WindChime: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🎐",
        description = "wind chime",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("wind-chime", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Activities: event: wind chime.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WindChime: Emoji get() = _WindChime
