package org.kodein.emoji.animals_nature.animal_marine

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllAnimalMarine() {
    add(intArrayOf(0x1f9ad), _Seal)
    add(intArrayOf(0x1f988), _Shark)
    add(intArrayOf(0x1f42c), _Dolphin)
    add(intArrayOf(0x1f40b), _Whale)
    add(intArrayOf(0x1f433), _SpoutingWhale)
    add(intArrayOf(0x1f41f), _Fish)
    add(intArrayOf(0x1f420), _TropicalFish)
    add(intArrayOf(0x1f421), _Blowfish)
    add(intArrayOf(0x1f419), _Octopus)
    add(intArrayOf(0x1fabc), _Jellyfish)
    add(intArrayOf(0x1fab8), _Coral)
    add(intArrayOf(0x1f41a), _SpiralShell)
}

internal fun MutableList<Emoji>.addAllAnimalMarine() {
    add(_Seal)
    add(_Shark)
    add(_Dolphin)
    add(_Whale)
    add(_SpoutingWhale)
    add(_Fish)
    add(_TropicalFish)
    add(_Blowfish)
    add(_Octopus)
    add(_Jellyfish)
    add(_Coral)
    add(_SpiralShell)
}

/**
 * All Emoji of the Animals & Nature: animal-marine subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allAnimalMarine(): List<Emoji> =
    ArrayList<Emoji>(12).apply { addAllAnimalMarine() }
