package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagCoTeDivoire: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇨🇮",
        description = "flag: Côte d’Ivoire",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-co-te-divoire", "co-te-divoire-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Côte d’Ivoire.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagCoTeDivoire: Emoji get() = _FlagCoTeDivoire

/**
 * Alias to emoji [FlagCoTeDivoire] (Flags: country-flag: flag: Côte d’Ivoire).
*/
public val Emoji.Companion.CoTeDivoireFlag: Emoji get() = _FlagCoTeDivoire
