package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagSolomonIslands: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇸🇧",
        description = "flag: Solomon Islands",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-solomon-islands", "solomon-islands-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Solomon Islands.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagSolomonIslands: Emoji get() = _FlagSolomonIslands

/**
 * Alias to emoji [FlagSolomonIslands] (Flags: country-flag: flag: Solomon Islands).
*/
public val Emoji.Companion.SolomonIslandsFlag: Emoji get() = _FlagSolomonIslands
