package org.kodein.emoji.objects.lock

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _LockedWithPen: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔏",
        description = "locked with pen",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("locked-with-pen", "lock-with-pen"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: lock: locked with pen.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.LockedWithPen: Emoji get() = _LockedWithPen

/**
 * Alias to emoji [LockedWithPen] (Objects: lock: locked with pen).
*/
public val Emoji.Companion.LockWithPen: Emoji get() = _LockedWithPen
