package org.kodein.emoji.objects.music

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Microphone: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🎤",
        description = "microphone",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("microphone", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: music: microphone.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Microphone: Emoji get() = _Microphone
