package org.kodein.emoji.people_body.person_activity

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonKneeling: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🧎",
        description = "person kneeling",
        unicodeVersion = UnicodeVersion(12, 0),
        aliases = listOf("person-kneeling", "kneeling"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-activity: person kneeling.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonKneeling: SkinTone1Emoji get() = _PersonKneeling

/**
 * Alias to emoji [PersonKneeling] (People & Body: person-activity: person kneeling).
*/
public val Emoji.Companion.Kneeling: SkinTone1Emoji get() = _PersonKneeling
