package org.kodein.emoji.people_body.person_gesture

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllPersonGesture() {
    add(intArrayOf(0x1f647), _PersonBowing)
    addVariations(intArrayOf(0x1f647, 0x0), _PersonBowing, 1)
    add(intArrayOf(0x1f64b), _PersonRaisingHand)
    addVariations(intArrayOf(0x1f64b, 0x0), _PersonRaisingHand, 1)
    add(intArrayOf(0x1f481), _PersonTippingHand)
    addVariations(intArrayOf(0x1f481, 0x0), _PersonTippingHand, 1)
    add(intArrayOf(0x1f646), _PersonGesturingOk)
    addVariations(intArrayOf(0x1f646, 0x0), _PersonGesturingOk, 1)
    add(intArrayOf(0x1f645), _PersonGesturingNo)
    addVariations(intArrayOf(0x1f645, 0x0), _PersonGesturingNo, 1)
    add(intArrayOf(0x1f937), _PersonShrugging)
    addVariations(intArrayOf(0x1f937, 0x0), _PersonShrugging, 1)
    add(intArrayOf(0x1f926), _PersonFacepalming)
    addVariations(intArrayOf(0x1f926, 0x0), _PersonFacepalming, 1)
    add(intArrayOf(0x1f64d), _PersonFrowning)
    addVariations(intArrayOf(0x1f64d, 0x0), _PersonFrowning, 1)
    add(intArrayOf(0x1f64e), _PersonPouting)
    addVariations(intArrayOf(0x1f64e, 0x0), _PersonPouting, 1)
    add(intArrayOf(0x1f9cf), _DeafPerson)
    addVariations(intArrayOf(0x1f9cf, 0x0), _DeafPerson, 1)
    add(intArrayOf(0x1f64d, 0x200d, 0x2642), _ManFrowning)
    addVariations(intArrayOf(0x1f64d, 0x0, 0x200d, 0x2642), _ManFrowning, 1)
    add(intArrayOf(0x1f64d, 0x200d, 0x2642, 0xfe0f), _ManFrowning)
    addVariations(intArrayOf(0x1f64d, 0x0, 0x200d, 0x2642, 0xfe0f), _ManFrowning, 1)
    add(intArrayOf(0x1f64d, 0x200d, 0x2640), _WomanFrowning)
    addVariations(intArrayOf(0x1f64d, 0x0, 0x200d, 0x2640), _WomanFrowning, 1)
    add(intArrayOf(0x1f64d, 0x200d, 0x2640, 0xfe0f), _WomanFrowning)
    addVariations(intArrayOf(0x1f64d, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanFrowning, 1)
    add(intArrayOf(0x1f64e, 0x200d, 0x2642), _ManPouting)
    addVariations(intArrayOf(0x1f64e, 0x0, 0x200d, 0x2642), _ManPouting, 1)
    add(intArrayOf(0x1f64e, 0x200d, 0x2642, 0xfe0f), _ManPouting)
    addVariations(intArrayOf(0x1f64e, 0x0, 0x200d, 0x2642, 0xfe0f), _ManPouting, 1)
    add(intArrayOf(0x1f64e, 0x200d, 0x2640), _WomanPouting)
    addVariations(intArrayOf(0x1f64e, 0x0, 0x200d, 0x2640), _WomanPouting, 1)
    add(intArrayOf(0x1f64e, 0x200d, 0x2640, 0xfe0f), _WomanPouting)
    addVariations(intArrayOf(0x1f64e, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanPouting, 1)
    add(intArrayOf(0x1f645, 0x200d, 0x2642), _ManGesturingNo)
    addVariations(intArrayOf(0x1f645, 0x0, 0x200d, 0x2642), _ManGesturingNo, 1)
    add(intArrayOf(0x1f645, 0x200d, 0x2642, 0xfe0f), _ManGesturingNo)
    addVariations(intArrayOf(0x1f645, 0x0, 0x200d, 0x2642, 0xfe0f), _ManGesturingNo, 1)
    add(intArrayOf(0x1f645, 0x200d, 0x2640), _WomanGesturingNo)
    addVariations(intArrayOf(0x1f645, 0x0, 0x200d, 0x2640), _WomanGesturingNo, 1)
    add(intArrayOf(0x1f645, 0x200d, 0x2640, 0xfe0f), _WomanGesturingNo)
    addVariations(intArrayOf(0x1f645, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanGesturingNo, 1)
    add(intArrayOf(0x1f646, 0x200d, 0x2642), _ManGesturingOk)
    addVariations(intArrayOf(0x1f646, 0x0, 0x200d, 0x2642), _ManGesturingOk, 1)
    add(intArrayOf(0x1f646, 0x200d, 0x2642, 0xfe0f), _ManGesturingOk)
    addVariations(intArrayOf(0x1f646, 0x0, 0x200d, 0x2642, 0xfe0f), _ManGesturingOk, 1)
    add(intArrayOf(0x1f646, 0x200d, 0x2640), _WomanGesturingOk)
    addVariations(intArrayOf(0x1f646, 0x0, 0x200d, 0x2640), _WomanGesturingOk, 1)
    add(intArrayOf(0x1f646, 0x200d, 0x2640, 0xfe0f), _WomanGesturingOk)
    addVariations(intArrayOf(0x1f646, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanGesturingOk, 1)
    add(intArrayOf(0x1f481, 0x200d, 0x2642), _ManTippingHand)
    addVariations(intArrayOf(0x1f481, 0x0, 0x200d, 0x2642), _ManTippingHand, 1)
    add(intArrayOf(0x1f481, 0x200d, 0x2642, 0xfe0f), _ManTippingHand)
    addVariations(intArrayOf(0x1f481, 0x0, 0x200d, 0x2642, 0xfe0f), _ManTippingHand, 1)
    add(intArrayOf(0x1f481, 0x200d, 0x2640), _WomanTippingHand)
    addVariations(intArrayOf(0x1f481, 0x0, 0x200d, 0x2640), _WomanTippingHand, 1)
    add(intArrayOf(0x1f481, 0x200d, 0x2640, 0xfe0f), _WomanTippingHand)
    addVariations(intArrayOf(0x1f481, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanTippingHand, 1)
    add(intArrayOf(0x1f64b, 0x200d, 0x2642), _ManRaisingHand)
    addVariations(intArrayOf(0x1f64b, 0x0, 0x200d, 0x2642), _ManRaisingHand, 1)
    add(intArrayOf(0x1f64b, 0x200d, 0x2642, 0xfe0f), _ManRaisingHand)
    addVariations(intArrayOf(0x1f64b, 0x0, 0x200d, 0x2642, 0xfe0f), _ManRaisingHand, 1)
    add(intArrayOf(0x1f64b, 0x200d, 0x2640), _WomanRaisingHand)
    addVariations(intArrayOf(0x1f64b, 0x0, 0x200d, 0x2640), _WomanRaisingHand, 1)
    add(intArrayOf(0x1f64b, 0x200d, 0x2640, 0xfe0f), _WomanRaisingHand)
    addVariations(intArrayOf(0x1f64b, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanRaisingHand, 1)
    add(intArrayOf(0x1f9cf, 0x200d, 0x2642), _DeafMan)
    addVariations(intArrayOf(0x1f9cf, 0x0, 0x200d, 0x2642), _DeafMan, 1)
    add(intArrayOf(0x1f9cf, 0x200d, 0x2642, 0xfe0f), _DeafMan)
    addVariations(intArrayOf(0x1f9cf, 0x0, 0x200d, 0x2642, 0xfe0f), _DeafMan, 1)
    add(intArrayOf(0x1f9cf, 0x200d, 0x2640), _DeafWoman)
    addVariations(intArrayOf(0x1f9cf, 0x0, 0x200d, 0x2640), _DeafWoman, 1)
    add(intArrayOf(0x1f9cf, 0x200d, 0x2640, 0xfe0f), _DeafWoman)
    addVariations(intArrayOf(0x1f9cf, 0x0, 0x200d, 0x2640, 0xfe0f), _DeafWoman, 1)
    add(intArrayOf(0x1f647, 0x200d, 0x2642), _ManBowing)
    addVariations(intArrayOf(0x1f647, 0x0, 0x200d, 0x2642), _ManBowing, 1)
    add(intArrayOf(0x1f647, 0x200d, 0x2642, 0xfe0f), _ManBowing)
    addVariations(intArrayOf(0x1f647, 0x0, 0x200d, 0x2642, 0xfe0f), _ManBowing, 1)
    add(intArrayOf(0x1f647, 0x200d, 0x2640), _WomanBowing)
    addVariations(intArrayOf(0x1f647, 0x0, 0x200d, 0x2640), _WomanBowing, 1)
    add(intArrayOf(0x1f647, 0x200d, 0x2640, 0xfe0f), _WomanBowing)
    addVariations(intArrayOf(0x1f647, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanBowing, 1)
    add(intArrayOf(0x1f926, 0x200d, 0x2642), _ManFacepalming)
    addVariations(intArrayOf(0x1f926, 0x0, 0x200d, 0x2642), _ManFacepalming, 1)
    add(intArrayOf(0x1f926, 0x200d, 0x2642, 0xfe0f), _ManFacepalming)
    addVariations(intArrayOf(0x1f926, 0x0, 0x200d, 0x2642, 0xfe0f), _ManFacepalming, 1)
    add(intArrayOf(0x1f926, 0x200d, 0x2640), _WomanFacepalming)
    addVariations(intArrayOf(0x1f926, 0x0, 0x200d, 0x2640), _WomanFacepalming, 1)
    add(intArrayOf(0x1f926, 0x200d, 0x2640, 0xfe0f), _WomanFacepalming)
    addVariations(intArrayOf(0x1f926, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanFacepalming, 1)
    add(intArrayOf(0x1f937, 0x200d, 0x2642), _ManShrugging)
    addVariations(intArrayOf(0x1f937, 0x0, 0x200d, 0x2642), _ManShrugging, 1)
    add(intArrayOf(0x1f937, 0x200d, 0x2642, 0xfe0f), _ManShrugging)
    addVariations(intArrayOf(0x1f937, 0x0, 0x200d, 0x2642, 0xfe0f), _ManShrugging, 1)
    add(intArrayOf(0x1f937, 0x200d, 0x2640), _WomanShrugging)
    addVariations(intArrayOf(0x1f937, 0x0, 0x200d, 0x2640), _WomanShrugging, 1)
    add(intArrayOf(0x1f937, 0x200d, 0x2640, 0xfe0f), _WomanShrugging)
    addVariations(intArrayOf(0x1f937, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanShrugging, 1)
}

internal fun MutableList<Emoji>.addAllPersonGesture() {
    add(_PersonBowing)
    add(_PersonRaisingHand)
    add(_PersonTippingHand)
    add(_PersonGesturingOk)
    add(_PersonGesturingNo)
    add(_PersonShrugging)
    add(_PersonFacepalming)
    add(_PersonFrowning)
    add(_PersonPouting)
    add(_DeafPerson)
    add(_ManFrowning)
    add(_WomanFrowning)
    add(_ManPouting)
    add(_WomanPouting)
    add(_ManGesturingNo)
    add(_WomanGesturingNo)
    add(_ManGesturingOk)
    add(_WomanGesturingOk)
    add(_ManTippingHand)
    add(_WomanTippingHand)
    add(_ManRaisingHand)
    add(_WomanRaisingHand)
    add(_DeafMan)
    add(_DeafWoman)
    add(_ManBowing)
    add(_WomanBowing)
    add(_ManFacepalming)
    add(_WomanFacepalming)
    add(_ManShrugging)
    add(_WomanShrugging)
}

/**
 * All Emoji of the People & Body: person-gesture subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allPersonGesture(): List<Emoji> =
    ArrayList<Emoji>(30).apply { addAllPersonGesture() }
