package org.kodein.emoji.people_body.person_resting

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllPersonResting() {
    add(intArrayOf(0x1f6c0), _PersonTakingBath)
    addVariations(intArrayOf(0x1f6c0, 0x0), _PersonTakingBath, 1)
    add(intArrayOf(0x1f6cc), _PersonInBed)
    addVariations(intArrayOf(0x1f6cc, 0x0), _PersonInBed, 1)
    add(intArrayOf(0x1f9d8), _PersonInLotusPosition)
    addVariations(intArrayOf(0x1f9d8, 0x0), _PersonInLotusPosition, 1)
    add(intArrayOf(0x1f9d8, 0x200d, 0x2642), _ManInLotusPosition)
    addVariations(intArrayOf(0x1f9d8, 0x0, 0x200d, 0x2642), _ManInLotusPosition, 1)
    add(intArrayOf(0x1f9d8, 0x200d, 0x2642, 0xfe0f), _ManInLotusPosition)
    addVariations(intArrayOf(0x1f9d8, 0x0, 0x200d, 0x2642, 0xfe0f), _ManInLotusPosition, 1)
    add(intArrayOf(0x1f9d8, 0x200d, 0x2640), _WomanInLotusPosition)
    addVariations(intArrayOf(0x1f9d8, 0x0, 0x200d, 0x2640), _WomanInLotusPosition, 1)
    add(intArrayOf(0x1f9d8, 0x200d, 0x2640, 0xfe0f), _WomanInLotusPosition)
    addVariations(intArrayOf(0x1f9d8, 0x0, 0x200d, 0x2640, 0xfe0f), _WomanInLotusPosition, 1)
}

internal fun MutableList<Emoji>.addAllPersonResting() {
    add(_PersonTakingBath)
    add(_PersonInBed)
    add(_PersonInLotusPosition)
    add(_ManInLotusPosition)
    add(_WomanInLotusPosition)
}

/**
 * All Emoji of the People & Body: person-resting subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allPersonResting(): List<Emoji> =
    ArrayList<Emoji>(5).apply { addAllPersonResting() }
