package org.kodein.emoji.smileys_emotion.face_glasses

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _NerdFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🤓",
        description = "nerd face",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("nerd-face", ),
        emoticons = listOf(":-B"),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-glasses: nerd face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.NerdFace: Emoji get() = _NerdFace
