package org.kodein.emoji.smileys_emotion.face_smiling

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _GrinningFaceWithSmilingEyes: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😄",
        description = "grinning face with smiling eyes",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("grinning-face-with-smiling-eyes", "grin"),
        emoticons = listOf("^_^"),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-smiling: grinning face with smiling eyes.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.GrinningFaceWithSmilingEyes: Emoji get() = _GrinningFaceWithSmilingEyes

/**
 * Alias to emoji [GrinningFaceWithSmilingEyes] (Smileys & Emotion: face-smiling: grinning face with smiling eyes).
*/
public val Emoji.Companion.Grin: Emoji get() = _GrinningFaceWithSmilingEyes
