package org.kodein.emoji.smileys_emotion.face_unwell

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FaceWithThermometer: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🤒",
        description = "face with thermometer",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("face-with-thermometer", "thermometer-face"),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-unwell: face with thermometer.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FaceWithThermometer: Emoji get() = _FaceWithThermometer

/**
 * Alias to emoji [FaceWithThermometer] (Smileys & Emotion: face-unwell: face with thermometer).
*/
public val Emoji.Companion.ThermometerFace: Emoji get() = _FaceWithThermometer
