package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _JapanesePassingGradeButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🈴",
        description = "Japanese “passing grade” button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("japanese-passing-grade-button", "passing-grade"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: alphanum: Japanese “passing grade” button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.JapanesePassingGradeButton: Emoji get() = _JapanesePassingGradeButton

/**
 * Alias to emoji [JapanesePassingGradeButton] (Symbols: alphanum: Japanese “passing grade” button).
*/
public val Emoji.Companion.PassingGrade: Emoji get() = _JapanesePassingGradeButton
