package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _JapaneseSecretButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "㊙️",
        description = "Japanese “secret” button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("japanese-secret-button", "secret"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: alphanum: Japanese “secret” button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.JapaneseSecretButton: Emoji get() = _JapaneseSecretButton

/**
 * Alias to emoji [JapaneseSecretButton] (Symbols: alphanum: Japanese “secret” button).
*/
public val Emoji.Companion.Secret: Emoji get() = _JapaneseSecretButton
