package org.kodein.emoji.symbols.arrow

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _DownArrow: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⬇️",
        description = "down arrow",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("down-arrow", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: arrow: down arrow.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.DownArrow: Emoji get() = _DownArrow
