package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BlackSmallSquare: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "▪️",
        description = "black small square",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("black-small-square", "black-square-small"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: geometric: black small square.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BlackSmallSquare: Emoji get() = _BlackSmallSquare

/**
 * Alias to emoji [BlackSmallSquare] (Symbols: geometric: black small square).
*/
public val Emoji.Companion.BlackSquareSmall: Emoji get() = _BlackSmallSquare
