package org.kodein.emoji.symbols.other_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _MedicalSymbol: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⚕️",
        description = "medical symbol",
        unicodeVersion = UnicodeVersion(4, 0),
        aliases = listOf("medical-symbol", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: other-symbol: medical symbol.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.MedicalSymbol: Emoji get() = _MedicalSymbol
