package org.kodein.emoji.symbols.religion

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _StarOfDavid: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "✡️",
        description = "star of David",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("star-of-david", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: religion: star of David.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.StarOfDavid: Emoji get() = _StarOfDavid
