package org.kodein.emoji.symbols.transport_sign

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WheelchairSymbol: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "♿",
        description = "wheelchair symbol",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("wheelchair-symbol", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: transport-sign: wheelchair symbol.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WheelchairSymbol: Emoji get() = _WheelchairSymbol
