package org.kodein.emoji.activities.arts_crafts

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FramedPicture: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🖼️",
        description = "framed picture",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("framed-picture", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Activities: arts & crafts: framed picture.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FramedPicture: Emoji get() = _FramedPicture
