package org.kodein.emoji.activities.arts_crafts

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllArtsCrafts() {
    add(intArrayOf(0x1f5bc, 0xfe0f), _FramedPicture)
    add(intArrayOf(0x1f5bc), _FramedPicture)
    add(intArrayOf(0x1f3a8), _ArtistPalette)
    add(intArrayOf(0x1faa1), _SewingNeedle)
    add(intArrayOf(0x1f9f5), _Thread)
    add(intArrayOf(0x1f9f6), _Yarn)
    add(intArrayOf(0x1f3ad), _PerformingArts)
    add(intArrayOf(0x1faa2), _Knot)
}

internal fun MutableList<Emoji>.addAllArtsCrafts() {
    add(_FramedPicture)
    add(_ArtistPalette)
    add(_SewingNeedle)
    add(_Thread)
    add(_Yarn)
    add(_PerformingArts)
    add(_Knot)
}

/**
 * All Emoji of the Activities: arts & crafts subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allArtsCrafts(): List<Emoji> =
    ArrayList<Emoji>(7).apply { addAllArtsCrafts() }
