package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagDenmark: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇩🇰",
        description = "flag: Denmark",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-denmark", "denmark-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Denmark.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagDenmark: Emoji get() = _FlagDenmark

/**
 * Alias to emoji [FlagDenmark] (Flags: country-flag: flag: Denmark).
*/
public val Emoji.Companion.DenmarkFlag: Emoji get() = _FlagDenmark
