package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagPitcairnIslands: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇵🇳",
        description = "flag: Pitcairn Islands",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-pitcairn-islands", "pitcairn-islands-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Pitcairn Islands.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagPitcairnIslands: Emoji get() = _FlagPitcairnIslands

/**
 * Alias to emoji [FlagPitcairnIslands] (Flags: country-flag: flag: Pitcairn Islands).
*/
public val Emoji.Companion.PitcairnIslandsFlag: Emoji get() = _FlagPitcairnIslands
