package org.kodein.emoji.food_drink.food_prepared

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllFoodPrepared() {
    add(intArrayOf(0x1f35e), _Bread)
    add(intArrayOf(0x1fad3), _Flatbread)
    add(intArrayOf(0x1f950), _Croissant)
    add(intArrayOf(0x1f956), _BaguetteBread)
    add(intArrayOf(0x1f96f), _Bagel)
    add(intArrayOf(0x1f9c7), _Waffle)
    add(intArrayOf(0x1f95e), _Pancakes)
    add(intArrayOf(0x1f373), _Cooking)
    add(intArrayOf(0x1f95a), _Egg)
    add(intArrayOf(0x1f9c0), _CheeseWedge)
    add(intArrayOf(0x1f953), _Bacon)
    add(intArrayOf(0x1f969), _CutOfMeat)
    add(intArrayOf(0x1f357), _PoultryLeg)
    add(intArrayOf(0x1f356), _MeatOnBone)
    add(intArrayOf(0x1f354), _Hamburger)
    add(intArrayOf(0x1f32d), _HotDog)
    add(intArrayOf(0x1f96a), _Sandwich)
    add(intArrayOf(0x1f968), _Pretzel)
    add(intArrayOf(0x1f35f), _FrenchFries)
    add(intArrayOf(0x1f355), _Pizza)
    add(intArrayOf(0x1fad4), _Tamale)
    add(intArrayOf(0x1f32e), _Taco)
    add(intArrayOf(0x1f32f), _Burrito)
    add(intArrayOf(0x1f959), _StuffedFlatbread)
    add(intArrayOf(0x1f9c6), _Falafel)
    add(intArrayOf(0x1f958), _ShallowPanOfFood)
    add(intArrayOf(0x1f96b), _CannedFood)
    add(intArrayOf(0x1fad5), _Fondue)
    add(intArrayOf(0x1f963), _BowlWithSpoon)
    add(intArrayOf(0x1f957), _GreenSalad)
    add(intArrayOf(0x1f372), _PotOfFood)
    add(intArrayOf(0x1f9c2), _Salt)
    add(intArrayOf(0x1f9c8), _Butter)
    add(intArrayOf(0x1f37f), _Popcorn)
}

internal fun MutableList<Emoji>.addAllFoodPrepared() {
    add(_Bread)
    add(_Flatbread)
    add(_Croissant)
    add(_BaguetteBread)
    add(_Bagel)
    add(_Waffle)
    add(_Pancakes)
    add(_Cooking)
    add(_Egg)
    add(_CheeseWedge)
    add(_Bacon)
    add(_CutOfMeat)
    add(_PoultryLeg)
    add(_MeatOnBone)
    add(_Hamburger)
    add(_HotDog)
    add(_Sandwich)
    add(_Pretzel)
    add(_FrenchFries)
    add(_Pizza)
    add(_Tamale)
    add(_Taco)
    add(_Burrito)
    add(_StuffedFlatbread)
    add(_Falafel)
    add(_ShallowPanOfFood)
    add(_CannedFood)
    add(_Fondue)
    add(_BowlWithSpoon)
    add(_GreenSalad)
    add(_PotOfFood)
    add(_Salt)
    add(_Butter)
    add(_Popcorn)
}

/**
 * All Emoji of the Food & Drink: food-prepared subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allFoodPrepared(): List<Emoji> =
    ArrayList<Emoji>(34).apply { addAllFoodPrepared() }
