package org.kodein.emoji.objects.clothing

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _GemStone: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💎",
        description = "gem stone",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("gem-stone", ),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Objects: clothing: gem stone.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.GemStone: Emoji get() = _GemStone
