package org.kodein.emoji.objects.medical

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _XRay: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🩻",
        description = "x-ray",
        unicodeVersion = UnicodeVersion(14, 0),
        aliases = listOf("x-ray", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: medical: x-ray.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.XRay: Emoji get() = _XRay
