package org.kodein.emoji.objects.tool

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BowAndArrow: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🏹",
        description = "bow and arrow",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("bow-and-arrow", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: tool: bow and arrow.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BowAndArrow: Emoji get() = _BowAndArrow
