package org.kodein.emoji.people_body.family

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone2Emoji
import org.kodein.emoji.SkinTone2EmojiZWJImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _CoupleWithHeart: SkinTone2Emoji = SkinTone2EmojiZWJImpl(
    details = Emoji.Details(
        string = "💑",
        description = "couple with heart",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("couple-with-heart", "people-with-heart"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
    zwjTemplate = "🧑‍❤‍🧑",
    zwjUnicodeVersion = UnicodeVersion(13, 1),
    sk21c = 2,
    sk22c = 7,
)

/**
 * Emoji People & Body: family: couple with heart.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.CoupleWithHeart: SkinTone2Emoji get() = _CoupleWithHeart

/**
 * Alias to emoji [CoupleWithHeart] (People & Body: family: couple with heart).
*/
public val Emoji.Companion.PeopleWithHeart: SkinTone2Emoji get() = _CoupleWithHeart
