package org.kodein.emoji.people_body.person

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonBeard: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🧔",
        description = "person: beard",
        unicodeVersion = UnicodeVersion(5, 0),
        aliases = listOf("person-beard", "beard"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person: person: beard.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonBeard: SkinTone1Emoji get() = _PersonBeard

/**
 * Alias to emoji [PersonBeard] (People & Body: person: person: beard).
*/
public val Emoji.Companion.Beard: SkinTone1Emoji get() = _PersonBeard
