package org.kodein.emoji.smileys_emotion.face_sleepy

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _DroolingFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🤤",
        description = "drooling face",
        unicodeVersion = UnicodeVersion(3, 0),
        aliases = listOf("drooling-face", "drool"),
        emoticons = listOf("(¯﹃¯)"),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-sleepy: drooling face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.DroolingFace: Emoji get() = _DroolingFace

/**
 * Alias to emoji [DroolingFace] (Smileys & Emotion: face-sleepy: drooling face).
*/
public val Emoji.Companion.Drool: Emoji get() = _DroolingFace
