package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _RadioButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔘",
        description = "radio button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("radio-button", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: geometric: radio button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.RadioButton: Emoji get() = _RadioButton
